#version 330

uniform mat4 worldview;
uniform mat4 worldviewproj;
#if GRASS
uniform mat4 world;
uniform float time;
uniform sampler2D noiseTex;
uniform vec4 fade;
uniform vec4 playerPos;
#endif
#if UNIFORM_COLOR_TEXIDX
uniform vec4 colour;
uniform float texIdx;
#endif

in vec4 vertex;
in vec3 normal;
in vec4 uv0; //uv, z: special, w: packed texture indices
#if TANGENT
in vec4 tangent;
#endif
#if (VERTEX_COLOR && (UNIFORM_COLOR_TEXIDX == 0))
in vec4 colour;
#endif

out vec4 pos;
out vec3 norm;
out vec2 uv;
out vec3 idx; //texIdx - dif, nor, asg
#if TANGENT
out vec3 tang;
out vec3 binorm;
#endif
#if VERTEX_COLOR
out vec4 vcolor;
#endif
#if GRASS
out vec4 worldPos;
#endif

void main()
{
#if VERTEX_COLOR
	vcolor = colour;
#endif

#if GRASS
	vec4 v1 = vertex;
	float noise = textureLod(noiseTex, vertex.xy/64.0 + time/vec2(7, 13), 0).r;
	v1.x += sin(time*3 + vertex.x) * uv0.z * noise * 0.08 + 0.08;
	v1.y += sin(time*11 + vertex.x) * uv0.z * noise * 0.003 + 0.003;
	//float dist = length((worldview * vertex).xyz);
	float dist = length(playerPos.xy - vertex.xy);
	float fadeOut = clamp((dist - fade.x)*fade.w, 0.0, 1.0);
	vcolor.a = fadeOut;
	worldPos = world * v1;
	worldPos.z = uv0.z;
	pos = worldview * v1;
	gl_Position = worldviewproj * v1;
#else
	pos = worldview * vertex;
	gl_Position = worldviewproj * vertex;
#endif
	norm = mat3(worldview) * normal;
	uv = uv0.xy;
	
#if UNIFORM_COLOR_TEXIDX
	float difIdx = texIdx;
#else
	float difIdx = uv0.w;
#endif
	float asgIdx = floor(difIdx/65536 + 0.5);
	difIdx -= asgIdx*65536;
	float norIdx = floor(difIdx/256 + 0.5);
	difIdx -= norIdx*256;
	idx = vec3(difIdx, norIdx, asgIdx);
	
#if TANGENT
	tang = mat3(worldview) * tangent.xyz;
	binorm = cross(norm, tang)*tangent.w;
#endif
}
